/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.data.api;

import com.Application;
import com.android.core.data.api.AndroidController;
import com.android.core.domain.AndroidService;
import com.android.files.domain.FilesService;
import com.android.product.domain.ProductService;
import com.android.product.domain.model.ProductDto;
import com.dto.LoginDto;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/android/product"})
public class ProductController
extends AndroidController<ProductDto> {
    private final FilesService filesService;

    @Autowired
    public ProductController(Application app, AndroidService<ProductDto> service, FilesService filesService) {
        super(app, service);
        this.filesService = filesService;
    }

    @ApiIgnore
    @GetMapping(value={"/pic-data/{picId}"}, produces={"image/png"})
    public ResponseEntity<Resource> getImage(@PathVariable String picId) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        return this.filesService.getPicture(picId);
    }

    @ApiIgnore
    @GetMapping(value={"/info"})
    public ResponseEntity<Map<String, Object>> getInfo(@RequestParam String productCode) {
        if (!this.app.packs.isUsePack1()) {
            return null;
        }
        return ((ProductService)this.service).getInfo(productCode);
    }
}

